package gov.va.genisis2.service.impl;

import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.service.ICommentHistoryService;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 586338
 * @author Getaneh Kassahun
 *
 */
@Service
public class CommentHistoryService implements ICommentHistoryService {

	/**
	 * The commentHistoryDao
	 * 
	 * */
	@Autowired
	private ICommentHistoryDao commentHistoryDao;

	/**
	 * This method is used to getCommentHistoryDao.
	 * @return this returns commentHistoryDao.
	 * 
	 * */
	public ICommentHistoryDao getCommentHistoryDao() {
		return commentHistoryDao;
	}
	
	/**
	 * This method is used to setCommentHistoryDao.
	 * @param commentHistoryDao The commentHistoryDao.
	 * 
	 * */
	public void setCommentHistoryDao(ICommentHistoryDao commentHistoryDao) {
		this.commentHistoryDao = commentHistoryDao;
	}
	
	/**
	 * This method is used to createCommentHistory.
	 * @param commentHistory The commentHistory.
	 * @return int This returns commentHistory id.
	 * 
	 * */
	@Override
	public int createCommentHistory(CommentHistory commentHistory) {
		return commentHistoryDao.createCommentHistory(commentHistory);
	}
	
	/**
	 * This method is used to updateCommentHistory.
	 * @param commentHistory The commentHistory.
	 * @return int This returns CommentHistory id.
	 * 
	 * */
	@Override
	public int updateCommentHistory(CommentHistory commentHistory) {
		return commentHistoryDao.updateCommentHistory(commentHistory);
	}
	
	/**
	 * This method is used to getCommentHistoriesByID.
	 * @param id The id.
	 * @return CommentHistory This returns CommentHistory.
	 * 
	 * */
	@Override
	public CommentHistory getCommentHistoriesByID(int id) {
		return commentHistoryDao.getCommentHistoriesByID(id);
	}
	
	/**
	 * This method is used to getCommentHistoriesByUID.
	 * @param uid The uid.
	 * @return this returns list of CommentHistories .
	 * 
	 * */
	@Override
	public List<CommentHistory> getCommentHistoriesByUID(String uid) {
		return commentHistoryDao.getCommentHistoriesByUID(uid);
	}
	
	/**
	 * This method is used to getCommentHistories.
	 * @return this returns list of CommentHistories .
	 * 
	 * */
	@Override
	public List<CommentHistory> getCommentHistories() {
		return commentHistoryDao.getCommentHistories();
	}
	
	/**
	 * This method is used to submitOrModify.
	 * @param commentHistory The commentHistory.
	 * @return int This returns list of CommentHistory id .
	 * 
	 * */
	@Override
	public int submitOrModify(CommentHistory commentHistory) {		
		return commentHistoryDao.submitOrModify(commentHistory);
	}

	/**
	 * This method is used to getCommentHistoryById.
	 * @param requestId The requestId.
	 * @return this returns list of CommentHistories .
	 * 
	 * */
	@Override
	public List<CommentHistory> getCommentHistoryById(int requestId) {
		return commentHistoryDao.getCommentHistoryById(requestId);
	}

	/**
	 * This method is used to getCommentHistoryByCommentId.
	 * @param commentId The commentId.
	 * @return CommentHistory This returns CommentHistory.
	 * 
	 * */
	@Override	
	public CommentHistory getCommentHistoryByCommentId(int commentId) {
	
		return commentHistoryDao.getCommentHistoryByCommentId(commentId);
	}

	/**
	 * This method is used to getCommentHistoryByRequestIdStatusId.
	 * @param requestId The requestId.
	 * @param taskId The taskId.
	 * @return this returns list of CommentHistories.
	 * 
	 * */
	@Override
	public List<CommentHistory> getCommentHistoryByRequestIdStatusId(
			int requestId,  String taskId) {
		
		return commentHistoryDao.getCommentHistoryByRequestIdStatusId(requestId, taskId);
	}

}
